from fleming.system_test.fle_sys import *
# Global Constants
PATH, SCRIPT = os.path.split(__file__)
BASE_NAME = SCRIPT.split('.')[0]
ADJUSTMENT_PATH = '/home/pkiuser/.config/pyrunner/'



async def readout_detectors(iterations, hv1 = 0.4, hv2 = 0.5, dl1 = 0.25, dl2 = 0.25, window=1000, pre_cnt_window=10000):
    # from mleuschner.pmt_test1.py:
    # async def darkcount(iterations, hv1 = 0.4, hv2 = 0.5, dl1 = 0.25, dl2 = 0.25, window=1000, pre_cnt_window=10000):
    
    # ml 210906: darkcount measurement
    # 10ns timer tick
    # 1µs = 100 ticks
    # 1ms = 100000 ticks
    
    measurement_unit: VUMeasurementUnit = VUnits.instance.hal.measurementUnit
    delay = 0.1


    await measurement_unit.MeasurementFunctions.SetParameter(MeasurementParameter.PMT1DiscriminatorLevel, dl1, timeout=1)
    await asyncio.sleep(delay)

    await measurement_unit.MeasurementFunctions.SetParameter(MeasurementParameter.PMT2DiscriminatorLevel, dl2, timeout=1)
    await asyncio.sleep(delay)

    await measurement_unit.MeasurementFunctions.SetParameter(MeasurementParameter.PMT1HighVoltageSetting, hv1, timeout=1)
    await asyncio.sleep(delay)

    await measurement_unit.MeasurementFunctions.SetParameter(MeasurementParameter.PMT2HighVoltageSetting, hv2, timeout=1)
    await asyncio.sleep(delay)
 
    await measurement_unit.MeasurementFunctions.SetParameter(MeasurementParameter.PMT1HighVoltageEnable, 1, timeout=1)
    await asyncio.sleep(delay)

    await measurement_unit.MeasurementFunctions.SetParameter(MeasurementParameter.PMT2HighVoltageEnable, 1, timeout=1)
    await asyncio.sleep(delay)

    await hvgate1on()

    await hvgate2on()

    ## IntegratorModes
    full_reset = 0b010
    low_range_reset = 0b011
    integrate_autorange = 0b100
    integrate_with_fixed_range = 0b101
    integrate_in_low_range = 0b110
    integrate_in_high_range = 0b111

    highresetdelay = 5000 # 50µs
    lowresetdelay = 5000  # 50µs
    meastime = 5000       # 50µs
    delaytime = 5000      # 50µs
    integdelay = 500      # 5µs
    #pre_cnt_window = 100    # 1µs
    wscale = 100000 // pre_cnt_window   # 1ms scale for window
    cnt_window = window * wscale
    window_corse, window_fine = divmod(cnt_window, 65536)

    op_id = 'darktest'
    seq_gen = meas_seq_generator()
    seq_gen.ClearResultBuffer(relative=False, dword=False, addrReg=0, addr=0)   # pmt1, count_result
    seq_gen.ClearResultBuffer(relative=False, dword=False, addrReg=0, addr=1)   # pmt1, analog_low_result
    seq_gen.ClearResultBuffer(relative=False, dword=False, addrReg=0, addr=2)   # pmt1, analog_high_result
    seq_gen.ClearResultBuffer(relative=False, dword=False, addrReg=0, addr=3)   # pmt1, analog_low_offset
    seq_gen.ClearResultBuffer(relative=False, dword=False, addrReg=0, addr=4)   # pmt1, analog_high_offset
    seq_gen.ClearResultBuffer(relative=False, dword=False, addrReg=0, addr=5)   # pmt2, count_result
    seq_gen.ClearResultBuffer(relative=False, dword=False, addrReg=0, addr=6)   # pmt2, analog_low_result
    seq_gen.ClearResultBuffer(relative=False, dword=False, addrReg=0, addr=7)   # pmt2, analog_high_result
    seq_gen.ClearResultBuffer(relative=False, dword=False, addrReg=0, addr=8)   # pmt2, analog_low_offset
    seq_gen.ClearResultBuffer(relative=False, dword=False, addrReg=0, addr=9)   # pmt2, analog_high_offset
    seq_gen.ClearResultBuffer(relative=False, dword=False, addrReg=0, addr=10)  # ref, analog_low_result
    seq_gen.ClearResultBuffer(relative=False, dword=False, addrReg=0, addr=11)  # ref, analog_high_result
    seq_gen.ClearResultBuffer(relative=False, dword=False, addrReg=0, addr=12)  # ref, analog_low_offset
    seq_gen.ClearResultBuffer(relative=False, dword=False, addrReg=0, addr=13)  # ref, analog_high_offset
    seq_gen.ClearResultBuffer(relative=False, dword=False, addrReg=0, addr=14)  # abs, analog_low_result
    seq_gen.ClearResultBuffer(relative=False, dword=False, addrReg=0, addr=15)  # abs, analog_high_result
    seq_gen.ClearResultBuffer(relative=False, dword=False, addrReg=0, addr=16)  # abs, analog_low_offset
    seq_gen.ClearResultBuffer(relative=False, dword=False, addrReg=0, addr=17)  # abs, analog_high_offset
    seq_gen.TimerWaitAndRestart(highresetdelay)
    seq_gen.SetSignals(OutputSignal.Flash)
    seq_gen.SetIntegratorMode(abs=full_reset, ref=full_reset, pmt2=full_reset, pmt1=full_reset)
    seq_gen.TimerWaitAndRestart(lowresetdelay)
    seq_gen.SetIntegratorMode(abs=low_range_reset, ref=low_range_reset, pmt2=low_range_reset, pmt1=low_range_reset)
    seq_gen.TimerWaitAndRestart(delaytime)
    # high range offset
    seq_gen.TimerWaitAndRestart(meastime)
    seq_gen.SetIntegratorMode(abs=integrate_in_high_range, ref=integrate_in_high_range, pmt2=integrate_in_high_range, pmt1=integrate_in_high_range)
    seq_gen.TimerWait()
    seq_gen.SetTriggerOutput(TriggerSignal.SampleRef | TriggerSignal.SampleAbs | TriggerSignal.SamplePMT1 | TriggerSignal.SamplePMT2)
    # channels: pmt1= 0; pmt2= 1; ref= 4; abs= 5
    seq_gen.GetAnalogResult(channel=0, isRelativeAddr=False, ignoreRange=False, isHiRange=True,  addResult=True, dword=False, addrPos=0, resultPos=4)
    seq_gen.GetAnalogResult(channel=1, isRelativeAddr=False, ignoreRange=False, isHiRange=True,  addResult=True, dword=False, addrPos=0, resultPos=9)
    seq_gen.GetAnalogResult(channel=4, isRelativeAddr=False, ignoreRange=False, isHiRange=True,  addResult=True, dword=False, addrPos=0, resultPos=13)
    seq_gen.GetAnalogResult(channel=5, isRelativeAddr=False, ignoreRange=False, isHiRange=True,  addResult=True, dword=False, addrPos=0, resultPos=17)
    # low range offset
    seq_gen.TimerWaitAndRestart(meastime)
    seq_gen.SetIntegratorMode(abs=integrate_in_low_range, ref=integrate_in_low_range, pmt2=integrate_in_low_range, pmt1=integrate_in_low_range)
    seq_gen.TimerWait()
    seq_gen.SetTriggerOutput(TriggerSignal.SampleRef | TriggerSignal.SampleAbs | TriggerSignal.SamplePMT1 | TriggerSignal.SamplePMT2)
    seq_gen.GetAnalogResult(channel=0, isRelativeAddr=False, ignoreRange=False, isHiRange=False, addResult=True, dword=False, addrPos=0, resultPos=3)
    seq_gen.GetAnalogResult(channel=1, isRelativeAddr=False, ignoreRange=False, isHiRange=False, addResult=True, dword=False, addrPos=0, resultPos=8)
    seq_gen.GetAnalogResult(channel=4, isRelativeAddr=False, ignoreRange=False, isHiRange=False, addResult=True, dword=False, addrPos=0, resultPos=12)
    seq_gen.GetAnalogResult(channel=5, isRelativeAddr=False, ignoreRange=False, isHiRange=False, addResult=True, dword=False, addrPos=0, resultPos=16)
    # measurement
    seq_gen.TimerWaitAndRestart(pre_cnt_window)
    seq_gen.SetIntegratorMode(abs=integrate_autorange, ref=integrate_autorange, pmt2=integrate_autorange, pmt1=integrate_autorange)
    seq_gen.PulseCounterControl(channel=0, cumulative=False, resetCounter=True, resetPresetCounter=True, correctionOn=False)
    seq_gen.PulseCounterControl(channel=1, cumulative=False, resetCounter=True, resetPresetCounter=True, correctionOn=False)
    if (window_corse > 0):
        seq_gen.Loop(window_corse)
        seq_gen.Loop(65536)
        seq_gen.TimerWaitAndRestart(pre_cnt_window)
        seq_gen.PulseCounterControl(channel=0, cumulative=True, resetCounter=False, resetPresetCounter=True, correctionOn=False)
        seq_gen.PulseCounterControl(channel=1, cumulative=True, resetCounter=False, resetPresetCounter=True, correctionOn=False)
        seq_gen.LoopEnd()
        seq_gen.LoopEnd()
    if (window_fine > 0):
        seq_gen.Loop(window_fine)
        seq_gen.TimerWaitAndRestart(pre_cnt_window)
        seq_gen.PulseCounterControl(channel=0, cumulative=True, resetCounter=False, resetPresetCounter=True, correctionOn=False)
        seq_gen.PulseCounterControl(channel=1, cumulative=True, resetCounter=False, resetPresetCounter=True, correctionOn=False)
        seq_gen.LoopEnd()
    seq_gen.TimerWaitAndRestart(integdelay)
    seq_gen.SetIntegratorMode(abs=integrate_with_fixed_range, ref=integrate_with_fixed_range, pmt2=integrate_with_fixed_range, pmt1=integrate_with_fixed_range)
    seq_gen.TimerWait()
    # read out analog signals
    seq_gen.GetPulseCounterResult(channel=0, relative=False, resetCounter=True, cumulative=True, dword=False, addrPos=0, resultPos=0)
    seq_gen.GetPulseCounterResult(channel=1, relative=False, resetCounter=True, cumulative=True, dword=False, addrPos=0, resultPos=5)
    seq_gen.SetTriggerOutput(TriggerSignal.SampleRef | TriggerSignal.SampleAbs | TriggerSignal.SamplePMT1 | TriggerSignal.SamplePMT2)
    seq_gen.GetAnalogResult(channel=0, isRelativeAddr=False, ignoreRange=False, isHiRange=False, addResult=True, dword=False, addrPos=0, resultPos=1)
    seq_gen.GetAnalogResult(channel=0, isRelativeAddr=False, ignoreRange=False, isHiRange=True,  addResult=True, dword=False, addrPos=0, resultPos=2)
    seq_gen.GetAnalogResult(channel=1, isRelativeAddr=False, ignoreRange=False, isHiRange=False, addResult=True, dword=False, addrPos=0, resultPos=6)
    seq_gen.GetAnalogResult(channel=1, isRelativeAddr=False, ignoreRange=False, isHiRange=True,  addResult=True, dword=False, addrPos=0, resultPos=7)
    seq_gen.GetAnalogResult(channel=4, isRelativeAddr=False, ignoreRange=False, isHiRange=False, addResult=True, dword=False, addrPos=0, resultPos=10)
    seq_gen.GetAnalogResult(channel=4, isRelativeAddr=False, ignoreRange=False, isHiRange=True,  addResult=True, dword=False, addrPos=0, resultPos=11)
    seq_gen.GetAnalogResult(channel=5, isRelativeAddr=False, ignoreRange=False, isHiRange=False, addResult=True, dword=False, addrPos=0, resultPos=14)
    seq_gen.GetAnalogResult(channel=5, isRelativeAddr=False, ignoreRange=False, isHiRange=True,  addResult=True, dword=False, addrPos=0, resultPos=15)
    seq_gen.SetIntegratorMode(abs=full_reset, ref=full_reset, pmt2=full_reset, pmt1=full_reset)
    seq_gen.Stop(0)

    measurement_unit.ClearOperations()
    measurement_unit.resultAddresses[op_id] = range(0, 18)
    await measurement_unit.LoadTriggerSequence(op_id, seq_gen.currSequence)


    result = str.format("iterations: {0}, Count-Window: {1}, PreCount-Window: {2}",iterations, cnt_window, pre_cnt_window)
    #report(result, '.pmt.darkcount1')
    #dfp = datapath('DarkCount')
    #path, filename = os.path.split(dfp)
    #report(filename, '.pmt.darkcount1'); #Write to Report
    #print (filename)
    with open(dfp, 'a') as data:
        data.write(f"iter\tpmt1_cr\tpmt1_alr\tpmt1_ahr\tpmt1_alo\tpmt1_aho\tpmt2_cr\tpmt2_alr\tpmt2_ahr\tpmt2_alo\tpmt2_aho\tref_alr\tref_ahr\tref_alo\tref_aho\tabs_alr\tabs_ahr\tabs_alo\tabs_aho\tTime\n")
        for i in range(iterations):
            try:
                time_stamp1 = dt.now().strftime('%H:%M:%S.%f')                
                await measurement_unit.ExecuteMeasurement(op_id)
                await asyncio.sleep(delay)
                results = await measurement_unit.ReadMeasurementValues(op_id)
                print(f"{i}\t{results[0]}\t{results[5]}")
                data.write(f"{i}\t{results[0]}\t{results[1]}\t{results[2]}\t{results[3]}\t{results[4]}\t{results[5]}\t{results[6]}\t{results[7]}\t{results[8]}\t{results[9]}\t{results[10]}\t{results[11]}\t{results[12]}\t{results[13]}\t{results[14]}\t{results[15]}\t{results[16]}\t{results[17]}\t{time_stamp1}\n")
            except BaseException as ex:
                print(f"darkcount() failed: {ex}")
                data.write(f"darkcount() failed: {ex}\n")
    await hvgate1off()
    await hvgate2off()
    await pmt1hvdisable()
    await pmt2hvdisable()
    return(0)
